/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.metadataintegration.blueprint;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.api.events.SpaceBlueprintHomePageCreateEvent;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.communardo.confluence.metadata.DataObject;
import com.communardo.confluence.metadata.MetadataException;
import com.communardo.confluence.metadata.MetadataField;
import com.communardo.confluence.metadata.MetadataFieldType;
import com.communardo.confluence.metadata.MetadataImportException;
import com.communardo.confluence.metadata.MetadataSet;
import com.communardo.confluence.metadata.fieldtype.Transferable;
import com.communardo.confluence.metadata.service.MetadataFieldTypeManager;
import com.communardo.confluence.metadata.service.MetadataManager;
import com.google.gson.Gson;
import de.communardo.confluence.plugins.metadataintegration.type.SmileyDataObject;
import de.communardo.confluence.plugins.metadataintegration.type.SmileyMetadataFieldType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named
public class MetadataIntegrationBlueprintEventListener
implements DisposableBean {
    private static final String FIELD_TYPE_TEXT = "TEXT";
    private static final String FIELD_TYPE_RADIOBUTTON = "RADIOBUTTON";
    private static final String OPTION_FAIL = "FAIL";
    private static final String OPTION_SUCCESS = "SUCCESS";
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataIntegrationBlueprintEventListener.class);
    private static final String BLUEPRINT_MODULE_KEY = "de.communardo.confluence.plugins.metadata-integration:metadata-integration-space-blueprint";
    @ComponentImport
    private final ContentPropertyManager contentPropertyManager;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final MetadataFieldTypeManager metadataFieldTypeManager;
    @ComponentImport
    private final MetadataManager metadataManager;

    @Inject
    public MetadataIntegrationBlueprintEventListener(SpaceManager spaceManager, ContentPropertyManager contentPropertyManager, EventPublisher eventPublisher, MetadataFieldTypeManager metadataFieldTypeManager, MetadataManager metadataManager) {
        this.contentPropertyManager = contentPropertyManager;
        this.spaceManager = spaceManager;
        this.eventPublisher = eventPublisher;
        this.metadataFieldTypeManager = metadataFieldTypeManager;
        this.metadataManager = metadataManager;
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onSpaceHomePageCreated(SpaceBlueprintHomePageCreateEvent homePageCreateEvent) {
        if (BLUEPRINT_MODULE_KEY.equals(homePageCreateEvent.getSpaceBlueprint().getModuleCompleteKey())) {
            Space space = homePageCreateEvent.getSpace();
            try {
                MetadataSet metadataSet = this.addMetadataStructureToSpace(space);
                this.metadataManager.saveContentMetadataSet((ContentEntityObject)space.getHomePage(), metadataSet);
                for (MetadataField field : metadataSet.getMetadataFields()) {
                    this.addMetadataValueToHomeSpacePage(space.getHomePage(), field);
                }
            }
            catch (MetadataImportException e) {
                LOGGER.error("Adding Metadata structure to space '{}' failed", (Object)space.getKey(), (Object)e);
            }
            catch (MetadataException e) {
                LOGGER.error("Adding Metadata set to the home page of space created by blueprint failed", (Throwable)e);
            }
        }
    }

    private void addMetadataValueToHomeSpacePage(Page homePage, MetadataField field) {
        MetadataFieldType fieldType = field.getType();
        if (!(fieldType instanceof Transferable)) {
            LOGGER.error("Unsupported Metadata field '{}' of type '{}'", (Object)field.getKey(), (Object)fieldType);
            return;
        }
        Transferable transferableFieldType = (Transferable)fieldType;
        DataObject dataObject = null;
        try {
            if (FIELD_TYPE_TEXT.equals(fieldType.getName())) {
                dataObject = transferableFieldType.createDataObject("Space home page successfully created.");
            } else if (FIELD_TYPE_RADIOBUTTON.equals(fieldType.getName())) {
                String exportFormat = new Gson().toJson(Arrays.asList(OPTION_SUCCESS));
                dataObject = transferableFieldType.createDataObject(exportFormat);
            } else if ("SMILEY".equals(fieldType.getName())) {
                dataObject = SmileyDataObject.getLaughingSmiley(SmileyMetadataFieldType.SmileyStyle.YELLOW);
            } else {
                LOGGER.error("Unsupported Metadata field '{}' of type '{}'", (Object)field.getKey(), (Object)fieldType);
            }
            if (dataObject != null) {
                this.metadataManager.saveContentMetadataValue((ContentEntityObject)homePage, field, dataObject);
            }
        }
        catch (MetadataException | MetadataImportException e) {
            LOGGER.error("Adding Metadata value of field '{}' to space home page failed", (Object)field.getKey(), (Object)e);
        }
    }

    private MetadataSet addMetadataStructureToSpace(Space space) throws MetadataImportException {
        ArrayList<MetadataField> metadataFields = new ArrayList<MetadataField>();
        metadataFields.add(this.createStatusMetadataField(space));
        metadataFields.add(this.createStatusMessageMetadataField(space));
        metadataFields.add(this.createSmileyMetadataField(space));
        MetadataSet exampleSet = new MetadataSet();
        exampleSet.setDefaultSet(true);
        exampleSet.setKey("metadataintegrationset");
        exampleSet.setTitle("Metadata integration set");
        exampleSet.setSpace(space);
        exampleSet.setMetadatas(metadataFields);
        this.metadataManager.saveMetadataSet(exampleSet);
        return exampleSet;
    }

    private MetadataField createSmileyMetadataField(Space space) throws MetadataImportException {
        MetadataField metadataField = this.createMetadataField("Smiley mood", "metadataintegrationsmileymood", this.getFieldType("SMILEY"), space, null);
        ((SmileyMetadataFieldType)metadataField.getType()).setYellowTypeConfiguration();
        return metadataField;
    }

    private MetadataField createStatusMetadataField(Space space) throws MetadataImportException {
        List<String> options = Arrays.asList(OPTION_SUCCESS, OPTION_FAIL);
        String fieldConfigExportFormat = new Gson().toJson(options);
        return this.createMetadataField("Status", "metadataintegrationstatus", this.getFieldType(FIELD_TYPE_RADIOBUTTON), space, fieldConfigExportFormat);
    }

    private MetadataField createStatusMessageMetadataField(Space space) throws MetadataImportException {
        return this.createMetadataField("Status message", "metadataintegrationstatusmessage", this.getFieldType(FIELD_TYPE_TEXT), space, null);
    }

    private MetadataFieldType getFieldType(String fieldTypeName) throws MetadataImportException {
        MetadataFieldType fieldType = this.metadataFieldTypeManager.getFieldTypeByName(fieldTypeName);
        if (fieldType == null) {
            throw new MetadataImportException("Field type with name " + fieldTypeName + " doesn't exist");
        }
        return fieldType;
    }

    private MetadataField createMetadataField(String fieldTitle, String fieldKey, MetadataFieldType fieldType, Space space, String fieldConfigInExportFormat) throws MetadataImportException {
        MetadataField metadataField = new MetadataField();
        metadataField.setKey(fieldKey);
        metadataField.setTitle(fieldTitle);
        metadataField.setType(fieldType);
        metadataField.setSpace(space);
        metadataField = this.metadataManager.saveMetadataField(metadataField);
        if (fieldConfigInExportFormat != null && (fieldType = metadataField.getType()) instanceof Transferable) {
            ((Transferable)fieldType).importTypeConfiguration(fieldConfigInExportFormat);
        }
        return metadataField;
    }
}

