/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.metadataintegration.type;

import com.communardo.confluence.metadata.DataObject;
import de.communardo.confluence.plugins.metadataintegration.type.SmileyMetadataFieldType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmileyDataObject
implements DataObject {
    private static final List<SmileyDataObject> ALL_SMILIES = SmileyDataObject.createAllSmilies();
    private static final Logger LOGGER = LoggerFactory.getLogger(SmileyDataObject.class);
    private final int id;

    private static List<SmileyDataObject> createAllSmilies() {
        ArrayList<SmileyDataObject> smilies = new ArrayList<SmileyDataObject>();
        for (int i = 1; i <= 6; ++i) {
            smilies.add(new SmileyDataObject(i));
        }
        return Collections.unmodifiableList(smilies);
    }

    public static List<SmileyDataObject> getAllSmilies() {
        return ALL_SMILIES;
    }

    public static SmileyDataObject fromId(int id) {
        int index = id - 1;
        if (index >= 0 && index < ALL_SMILIES.size()) {
            return ALL_SMILIES.get(index);
        }
        return null;
    }

    public static SmileyDataObject fromExportFormat(String exportFormat) {
        return SmileyDataObject.fromStringRepresentation(exportFormat);
    }

    public static SmileyDataObject fromStorageFormat(String storageFormat) {
        return SmileyDataObject.fromStringRepresentation(storageFormat);
    }

    private static SmileyDataObject fromStringRepresentation(String savedFormat) {
        if (StringUtils.isNotBlank((String)savedFormat)) {
            try {
                return SmileyDataObject.fromId(Integer.parseInt(savedFormat));
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Smiley ID '{}' is not an integer", (Object)savedFormat);
            }
        }
        return null;
    }

    public static SmileyDataObject getLaughingSmiley(SmileyMetadataFieldType.SmileyStyle smileyStyle) {
        if (SmileyMetadataFieldType.SmileyStyle.BLUE == smileyStyle) {
            return SmileyDataObject.fromId(1);
        }
        return SmileyDataObject.fromId(6);
    }

    private SmileyDataObject(int id) {
        this.id = id;
    }

    public String getImageUrl(String contextPath, String smileyStyle) {
        return contextPath + "/download/resources/de.communardo.confluence.plugins.metadata-integration%3Aintegration-resources/images/" + smileyStyle + this.id + ".png";
    }

    public String getEmojiCharacters(SmileyMetadataFieldType.SmileyStyle smileyStyle) {
        if (smileyStyle == SmileyMetadataFieldType.SmileyStyle.YELLOW) {
            switch (this.id) {
                case 1: {
                    return "\ud83d\ude0a";
                }
                case 2: {
                    return "\ud83d\ude06";
                }
                case 3: {
                    return "\ud83d\ude15";
                }
                case 4: {
                    return "\ud83d\ude0e";
                }
                case 5: {
                    return "\ud83d\ude17";
                }
                case 6: {
                    return "\ud83e\udd74";
                }
            }
            return "Unknown emoji";
        }
        switch (this.id) {
            case 1: {
                return "\ud83d\ude42";
            }
            case 2: {
                return "\ud83d\ude16";
            }
            case 3: {
                return "\ud83d\ude08";
            }
            case 4: {
                return "\ud83d\ude0c";
            }
            case 5: {
                return "\ud83d\ude27";
            }
            case 6: {
                return "\ud83d\ude2e";
            }
        }
        return "Unknown emoji";
    }

    public boolean isEqual(DataObject object) {
        return this.equals(object);
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmileyDataObject other = (SmileyDataObject)obj;
        return this.id == other.id;
    }

    public String toExportFormat() {
        return this.toStringRepresentation();
    }

    public String toStorageFormat() {
        return this.toStringRepresentation();
    }

    private String toStringRepresentation() {
        return "" + this.id;
    }
}

