/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.metadataintegration.type;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.querylang.fields.FieldHandler;
import com.atlassian.querylang.fields.UISupport;
import com.atlassian.querylang.fields.ValueType;
import com.atlassian.sal.api.message.I18nResolver;
import com.communardo.confluence.metadata.DataObject;
import com.communardo.confluence.metadata.MetadataExportException;
import com.communardo.confluence.metadata.MetadataField;
import com.communardo.confluence.metadata.MetadataFieldType;
import com.communardo.confluence.metadata.MetadataImportException;
import com.communardo.confluence.metadata.MetadataSet;
import com.communardo.confluence.metadata.cql.MetadataSchemaField;
import com.communardo.confluence.metadata.fieldtype.DefaultValueSupport;
import com.communardo.confluence.metadata.fieldtype.Transferable;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.communardo.confluence.plugins.metadataintegration.type.SmileyDataObject;
import de.communardo.confluence.plugins.metadataintegration.type.cql.SmileyMetadataFieldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;

public class SmileyMetadataFieldType
extends MetadataFieldType
implements Transferable,
DefaultValueSupport {
    private static final String FIELD_CONFIG_SMILEY_STYLE = "smileytype";
    public static final String FIELD_TYPE_NAME = "SMILEY";
    private final I18nResolver i18nResolver;
    private final BandanaManager bandanaManager;
    private final ContentPropertyManager contentPropertyManager;

    @Inject
    public SmileyMetadataFieldType(@ComponentImport I18nResolver i18nResolver, @ComponentImport BandanaManager bandanaManager, @ComponentImport ContentPropertyManager contentPropertyManager) {
        this.bandanaManager = bandanaManager;
        this.i18nResolver = i18nResolver;
        this.contentPropertyManager = contentPropertyManager;
    }

    public String getName() {
        return FIELD_TYPE_NAME;
    }

    public String renderData(DataObject dataObject, ContentEntityObject contentEntityObject) {
        Map defaultVelocityContext = MacroUtils.defaultVelocityContext();
        defaultVelocityContext.put("smileyStyle", this.loadSmileyStyle().toString());
        defaultVelocityContext.put("currentSmiley", dataObject);
        return VelocityUtils.getRenderedTemplate((String)"template/smiley_type_view.vm", (Map)defaultVelocityContext);
    }

    public String renderEdit(ContentEntityObject contentEntityObject) {
        return this.renderEdit(this.loadDataObject(contentEntityObject));
    }

    public String renderEdit(DataObject dataObject) {
        return this.renderSmileyValueEditView(this.getMetadataField(), dataObject);
    }

    public FieldHandler getCqlSearchFieldHandler(MetadataSchemaField schemaField) {
        return new SmileyMetadataFieldHandler(schemaField, true);
    }

    public String renderAdmin() {
        Map defaultVelocityContext = MacroUtils.defaultVelocityContext();
        defaultVelocityContext.put("currentSmileyStyle", this.loadSmileyStyle().toString());
        defaultVelocityContext.put("BLUE_STYLE", SmileyStyle.BLUE.toString());
        defaultVelocityContext.put("YELLOW_STYLE", SmileyStyle.YELLOW.toString());
        return VelocityUtils.getRenderedTemplate((String)"template/smiley_type_admin.vm", (Map)defaultVelocityContext);
    }

    public boolean onSaveMetadataField(Map parameters) {
        HashMap<String, String> typeConfig = new HashMap<String, String>();
        String[] style = (String[])parameters.get("smileyStyle");
        if (style != null && style.length > 0) {
            typeConfig.put(FIELD_CONFIG_SMILEY_STYLE, this.resolveSmileyStyle(style[0].trim()).toString());
        }
        this.updateTypeConfiguration(typeConfig);
        return true;
    }

    public void onRemoveMetadataField() {
        this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(), this.getTypeConfigBandanaStorarageKey());
    }

    private String getTypeConfigBandanaStorarageKey() {
        return this.getTypeConfigBandanaStorarageKey(this.getMetadataField());
    }

    private String getTypeConfigBandanaStorarageKey(MetadataField metadataField) {
        if (metadataField == null) {
            return null;
        }
        return "SMILEYTYPECONFIG-" + (metadataField.getSpace() != null ? metadataField.getSpace().getKey() : "global") + metadataField.getKey();
    }

    private void updateTypeConfiguration(Map<String, String> smileyConfig) {
        String bandanaStorageKey = this.getTypeConfigBandanaStorarageKey();
        if (bandanaStorageKey != null) {
            Gson gson = new Gson();
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), bandanaStorageKey, (Object)gson.toJson(smileyConfig));
        }
    }

    private Map<String, String> loadTypeConfiguration() {
        return this.loadTypeConfiguration(this.getMetadataField());
    }

    private Map<String, String> loadTypeConfiguration(MetadataField metadataField) {
        String storedSmileyConfig = null;
        String bandanaStorageKey = this.getTypeConfigBandanaStorarageKey(metadataField);
        if (bandanaStorageKey != null) {
            storedSmileyConfig = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), bandanaStorageKey);
        }
        TypeToken<Map<String, String>> typeToken = new TypeToken<Map<String, String>>(){};
        if (StringUtils.isBlank(storedSmileyConfig)) {
            return new HashMap<String, String>();
        }
        return (Map)new Gson().fromJson(storedSmileyConfig, typeToken.getType());
    }

    public SmileyStyle loadSmileyStyle() {
        return this.loadSmileyStyle(this.getMetadataField());
    }

    private SmileyStyle loadSmileyStyle(MetadataField metadataField) {
        return this.resolveSmileyStyle(this.loadTypeConfiguration(metadataField).get(FIELD_CONFIG_SMILEY_STYLE));
    }

    private SmileyStyle resolveSmileyStyle(String style) {
        if (SmileyStyle.YELLOW.toString().equals(style)) {
            return SmileyStyle.YELLOW;
        }
        return SmileyStyle.BLUE;
    }

    public Collection<String> getSearchIndexValue(ContentEntityObject contentEntityObject) {
        DataObject dataObject = this.loadDataObject(contentEntityObject);
        return this.getSearchIndexValue(dataObject);
    }

    public Collection<String> getSearchIndexValue(DataObject dataObject) {
        ArrayList<String> result = new ArrayList<String>();
        if (dataObject instanceof SmileyDataObject) {
            result.add(String.valueOf(((SmileyDataObject)dataObject).getId()));
        }
        return result;
    }

    public DataObject createDataObject(Map map) {
        String[] object = (String[])map.get("metadatavalue-" + this.getMetadataField().getId());
        if (object != null && object.length > 0) {
            return SmileyDataObject.fromStorageFormat(object[0]);
        }
        return null;
    }

    public DataObject loadDataObject(ContentEntityObject contentEntityObject) {
        if (contentEntityObject != null) {
            String loadContentMetadataValue = this.contentPropertyManager.getStringProperty(contentEntityObject, this.getMetadataField().getKey());
            return SmileyDataObject.fromStorageFormat(loadContentMetadataValue);
        }
        return null;
    }

    public void saveDataObject(ContentEntityObject contentEntityObject, DataObject dataObject) {
        if (dataObject instanceof SmileyDataObject) {
            this.contentPropertyManager.setStringProperty(contentEntityObject, this.getMetadataField().getKey(), ((SmileyDataObject)dataObject).toStorageFormat());
        }
    }

    public void removeDataObject(ContentEntityObject contentEntityObject) {
        this.contentPropertyManager.removeProperty(contentEntityObject, this.getMetadataField().getKey());
    }

    public UISupport getCqlUiSupport() {
        UISupport.Builder uiSupportBuilder = UISupport.builder().valueType(ValueType.STRING_TYPE).i18nKey(HtmlUtil.htmlEncode((String)this.getMetadataField().getTitle()) + (this.getMetadataField().getSpace() != null ? " (" + this.getMetadataField().getSpace().getKey() + ")" : ""));
        uiSupportBuilder.defaultOperator("=");
        uiSupportBuilder.dataUri("/rest/communardo/metadata-integration-example/latest/smiley-values/" + this.getMetadataField().getId());
        return uiSupportBuilder.build();
    }

    @Deprecated
    public void importTypeData(String exportedConfiguration) throws Exception {
        this.importTypeConfiguration(exportedConfiguration);
    }

    public DataObject copyDataObject(DataObject sourceDataObject, MetadataField targetMetadataField) {
        return sourceDataObject;
    }

    public DataObject createDataObject(String exportFormat) throws MetadataImportException {
        return SmileyDataObject.fromExportFormat(exportFormat);
    }

    public String exportDataObject(ContentEntityObject contentEntityObject) throws MetadataExportException {
        SmileyDataObject value = (SmileyDataObject)this.loadDataObject(contentEntityObject);
        if (value != null) {
            return value.toExportFormat();
        }
        return null;
    }

    public String exportTypeConfiguration() throws MetadataExportException {
        return this.convertSmileyStyleToJson(this.loadSmileyStyle());
    }

    public void importTypeConfiguration(String exportedConfiguration) throws MetadataImportException {
        SmileyStyle smileyTypeConfig = this.parseSmileyTypeConfigurationJson(exportedConfiguration);
        Map<String, String> typeConfiguration = this.loadTypeConfiguration();
        typeConfiguration.put(FIELD_CONFIG_SMILEY_STYLE, smileyTypeConfig.toString());
        this.updateTypeConfiguration(typeConfiguration);
    }

    public void setYellowTypeConfiguration() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(FIELD_CONFIG_SMILEY_STYLE, SmileyStyle.YELLOW.toString());
        this.updateTypeConfiguration(config);
    }

    private String convertSmileyStyleToJson(SmileyStyle smileyStyle) {
        JsonObject json = new JsonObject();
        json.addProperty(FIELD_CONFIG_SMILEY_STYLE, smileyStyle.toString());
        Gson gson = new Gson();
        return gson.toJson((JsonElement)json);
    }

    private SmileyStyle parseSmileyTypeConfigurationJson(String smileyTypeConfigJson) throws MetadataImportException {
        Gson gson = new Gson();
        try {
            JsonObject config = (JsonObject)gson.fromJson(smileyTypeConfigJson, JsonObject.class);
            return this.resolveSmileyStyle(config.get(FIELD_CONFIG_SMILEY_STYLE).getAsString());
        }
        catch (JsonSyntaxException | UnsupportedOperationException e) {
            throw new MetadataImportException("Parsing the smiley type configuration JSON failed.", e);
        }
    }

    private String renderSmileyValueEditView(MetadataField metadataField, DataObject object) {
        Map defaultVelocityContext = MacroUtils.defaultVelocityContext();
        defaultVelocityContext.put("currentSmiley", object);
        defaultVelocityContext.put("allSmilies", SmileyDataObject.getAllSmilies());
        defaultVelocityContext.put("smileyStyle", this.loadSmileyStyle(metadataField).toString());
        defaultVelocityContext.put("metadataField", metadataField);
        defaultVelocityContext.put("i18n", this.i18nResolver);
        return VelocityUtils.getRenderedTemplate((String)"template/smiley_type_edit.vm", (Map)defaultVelocityContext);
    }

    public DataObject loadDefaultValue(MetadataSet metadataSet, MetadataField metadataField) {
        String defaultValue = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), this.getSmileyDefaultValueBandanaKey(metadataSet, metadataField));
        return SmileyDataObject.fromStorageFormat(defaultValue);
    }

    private String getSmileyDefaultValueBandanaKey(MetadataSet metadataSet, MetadataField metadataField) {
        return "smiley-default-value" + metadataField.getId() + "_" + metadataSet.getId();
    }

    public void saveDefaultValue(Map<String, String[]> parameters, MetadataSet metadataSet, MetadataField metadataField) {
        DataObject dataObject = this.createDataObject(parameters);
        this.saveDefaultValue(metadataSet, metadataField, dataObject);
    }

    public void saveDefaultValue(MetadataSet metadataSet, MetadataField metadataField, DataObject dataObject) {
        if (dataObject instanceof SmileyDataObject) {
            String storedDefaultValue = ((SmileyDataObject)dataObject).toStorageFormat();
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), this.getSmileyDefaultValueBandanaKey(metadataSet, metadataField), (Object)storedDefaultValue);
        }
    }

    public void deleteDefaultValue(MetadataSet metadataSet, MetadataField metadataField) {
        this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(), this.getSmileyDefaultValueBandanaKey(metadataSet, metadataField));
    }

    public String renderDefaultValueEdit(MetadataSet metadataSet, MetadataField metadataField, DataObject object) {
        return this.renderSmileyValueEditView(metadataField, object);
    }

    public String exportDefaultValueConfiguration(MetadataSet metadataSet, MetadataField metadataField) throws MetadataExportException {
        SmileyDataObject defaultValue = (SmileyDataObject)this.loadDefaultValue(metadataSet, metadataField);
        return defaultValue != null ? defaultValue.toExportFormat() : null;
    }

    public void importDefaultValueConfiguration(MetadataSet metadataSet, MetadataField metadataField, String exportedConfiguration) throws MetadataImportException {
        if (StringUtils.isNotBlank((String)exportedConfiguration)) {
            this.saveDefaultValue(metadataSet, metadataField, SmileyDataObject.fromExportFormat(exportedConfiguration));
        }
    }

    public static enum SmileyStyle {
        BLUE,
        YELLOW;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

