/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.metadataintegration.type.cql;

import com.communardo.confluence.metadata.MetadataField;
import com.communardo.confluence.metadata.MetadataFieldType;
import com.communardo.confluence.metadata.service.MetadataManager;
import de.communardo.confluence.plugins.metadataintegration.type.SmileyDataObject;
import de.communardo.confluence.plugins.metadataintegration.type.SmileyMetadataFieldType;
import de.communardo.confluence.plugins.metadataintegration.type.cql.CqlMetadataSmileyEntity;
import de.communardo.confluence.plugins.metadataintegration.type.cql.CqlSmileyResultEntity;
import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;

@Path(value="/smiley-values")
public class CqlSmileyResources {
    static final String RESOURCE_PATH = "/smiley-values";
    static final String FILTER_SUB_PATH = "/{metadataFieldId}";
    private final MetadataManager metadataManager;

    public CqlSmileyResources(MetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{metadataFieldId}")
    public Response searchConfluenceSmileys(@PathParam(value="metadataFieldId") long metadataFieldId, @QueryParam(value="query") String query, @Context UriInfo uriInfo) {
        MetadataFieldType fieldType;
        ArrayList<CqlMetadataSmileyEntity> results = new ArrayList<CqlMetadataSmileyEntity>();
        ArrayList<CqlMetadataSmileyEntity> suggestedResults = new ArrayList<CqlMetadataSmileyEntity>();
        MetadataField metadataField = this.metadataManager.loadMetadataField(metadataFieldId);
        if (metadataField != null && (fieldType = metadataField.getType()) instanceof SmileyMetadataFieldType) {
            SmileyMetadataFieldType smileyType = (SmileyMetadataFieldType)fieldType;
            SmileyMetadataFieldType.SmileyStyle smileyStyleConfiguration = smileyType.loadSmileyStyle();
            for (SmileyDataObject smileyDataObject : SmileyDataObject.getAllSmilies()) {
                String smileyId = String.valueOf(smileyDataObject.getId());
                CqlMetadataSmileyEntity cqlMetadataSmileyEntity = new CqlMetadataSmileyEntity(smileyId, smileyDataObject.getEmojiCharacters(smileyStyleConfiguration));
                if (StringUtils.isBlank((String)query)) {
                    suggestedResults.add(cqlMetadataSmileyEntity);
                    continue;
                }
                if (!smileyId.toLowerCase().contains(query.toLowerCase())) continue;
                results.add(cqlMetadataSmileyEntity);
            }
        }
        return Response.ok((Object)new CqlSmileyResultEntity(results, suggestedResults)).build();
    }
}

