package de.communardo.confluence.plugins.metadataintegration.blueprint;

import com.atlassian.confluence.plugins.createcontent.TemplateRendererHelper;
import com.atlassian.confluence.plugins.createcontent.actions.DefaultBlueprintContentGenerator;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.AbstractBlueprintContextProvider;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContext;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContextKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.apache.commons.lang.StringUtils;

import javax.inject.Inject;

public class MetadataBlueprintIntegrationContextProvider extends AbstractBlueprintContextProvider {

    @Inject
    public MetadataBlueprintIntegrationContextProvider(@ComponentImport TemplateRendererHelper templateRendererHelper) {
        super(templateRendererHelper);
    }

    @Override
    protected BlueprintContext updateBlueprintContext(BlueprintContext blueprintContext) {

        // avoid that child page titles get prefixed with title of space homepage
        blueprintContext.put(BlueprintContextKeys.NO_PAGE_TITLE_PREFIX.key(), "true");
        addVariablesForSpace(blueprintContext);
        blueprintContext.put(DefaultBlueprintContentGenerator.CONTENT_PAGE_TITLE_CONTEXT_KEY,
                "Welcome to the Metadata integration space");

        return blueprintContext;
    }

    private void addVariablesForSpace(BlueprintContext blueprintContext) {
        String spaceKey = blueprintContext.getSpaceKey();
        if (!StringUtils.isBlank(spaceKey)) {
            blueprintContext.put("spaceKeyXhtml", "<ri:space ri:space-key=\"" + spaceKey + "\" />");
            blueprintContext.put("spaceKeyString", spaceKey);
        }
    }

}