package de.communardo.confluence.plugins.metadataintegration.type;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.communardo.confluence.metadata.MetadataField;
import com.communardo.confluence.metadata.MetadataSet;
import com.communardo.confluence.metadata.event.RemoveMetadataSetEvent;
import org.springframework.beans.factory.DisposableBean;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.List;

/**
 * Event Listener which removes default values for {@link SmileyMetadataFieldType}
 * when a set is removed
 * <br>
 * NOTE: This is only needed as a workaround for a bug <a href="https://jira.communardo.de/browse/METADATA-2518">METADATA-2518</a>
 */
@Named
public class MetadataDefaultValueCleanup implements DisposableBean {

    @ComponentImport
    private final EventPublisher eventPublisher;

    @Inject
    public MetadataDefaultValueCleanup(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        eventPublisher.register(this);
    }

    @Override
    public void destroy() {
        eventPublisher.unregister(this);
    }

    @EventListener
    public void onSetDelete(RemoveMetadataSetEvent event) {
        MetadataSet metadataSet = event.getOldMetadataSet();
        List<MetadataField> metadataFields = metadataSet.getMetadataFields();
        for (MetadataField field : metadataFields) {
            if (field.getType() instanceof SmileyMetadataFieldType) {
                ((SmileyMetadataFieldType) field.getType()).deleteDefaultValue(metadataSet, field);
            }
        }
    }
}
