package de.communardo.confluence.plugins.metadataintegration.type;

import com.communardo.confluence.metadata.DataObject;
import de.communardo.confluence.plugins.metadataintegration.type.SmileyMetadataFieldType.SmileyStyle;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SmileyDataObject implements DataObject {

    private static final List<SmileyDataObject> ALL_SMILIES = createAllSmilies();

    private static final Logger LOGGER = LoggerFactory.getLogger(SmileyDataObject.class);

    private final int id;


    private static List<SmileyDataObject> createAllSmilies() {
        ArrayList<SmileyDataObject> smilies = new ArrayList<>();
        for (int i = 1; i <= 6; i++) {
            smilies.add(new SmileyDataObject(i));
        }
        return Collections.unmodifiableList(smilies);
    }

    public static List<SmileyDataObject> getAllSmilies() {
        return ALL_SMILIES;
    }

    public static SmileyDataObject fromId(int id) {
        int index = id - 1;
        if (index >= 0 && index < ALL_SMILIES.size()) {
            return ALL_SMILIES.get(index);
        }
        return null;
    }

    public static SmileyDataObject fromExportFormat(String exportFormat) {
        return fromStringRepresentation(exportFormat);
    }

    public static SmileyDataObject fromStorageFormat(String storageFormat) {
        return fromStringRepresentation(storageFormat);
    }

    private static SmileyDataObject fromStringRepresentation(String savedFormat) {
        if (StringUtils.isNotBlank(savedFormat)) {
            try {
                return fromId(Integer.parseInt(savedFormat));
            } catch (NumberFormatException e) {
                LOGGER.debug("Smiley ID '{}' is not an integer", savedFormat);
            }
        }
        return null;
    }

    public static SmileyDataObject getLaughingSmiley(SmileyStyle smileyStyle) {
        if (SmileyStyle.BLUE == smileyStyle) {
            return SmileyDataObject.fromId(1);
        }
        return SmileyDataObject.fromId(6);
    }

    private SmileyDataObject(int id) {
        this.id = id;
    }

    public String getImageUrl(String contextPath, String smileyStyle) {
        // note: colon has to be URL encoded
        return contextPath
                + "/download/resources/de.communardo.confluence.plugins.metadata-integration%3Aintegration-resources/images/"
                + smileyStyle + id + ".png";
    }

    public String getEmojiCharacters(SmileyStyle smileyStyle){
        if (smileyStyle == SmileyMetadataFieldType.SmileyStyle.YELLOW) {
            switch (id) {
                case 1: return "\uD83D\uDE0A";
                case 2: return "\uD83D\uDE06";
                case 3: return 	"\uD83D\uDE15";
                case 4: return "\uD83D\uDE0E";
                case 5: return 	"\uD83D\uDE17";
                case 6: return "\uD83E\uDD74";
                default: return "Unknown emoji";
            }
        } else {
            switch (id) {
                case 1: return 	"\uD83D\uDE42";
                case 2: return 	"\uD83D\uDE16";
                case 3: return "\uD83D\uDE08";
                case 4: return 	"\uD83D\uDE0C";
                case 5: return 	"\uD83D\uDE27";
                case 6: return 	"\uD83D\uDE2E";
                default: return "Unknown emoji";
            }
        }

    }

    @Override
    public boolean isEqual(DataObject object) {
        return this.equals(object);
    }

    public int getId() {
        return id;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + id;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        SmileyDataObject other = (SmileyDataObject) obj;
        return id == other.id;
    }

    public String toExportFormat() {
        return toStringRepresentation();
    }

    public String toStorageFormat() {
        return toStringRepresentation();
    }

    private String toStringRepresentation() {
        return "" + id;
    }
}