package de.communardo.confluence.plugins.metadataintegration.type.cql;

import com.communardo.confluence.metadata.MetadataField;
import com.communardo.confluence.metadata.MetadataFieldType;
import com.communardo.confluence.metadata.service.MetadataManager;
import de.communardo.confluence.plugins.metadataintegration.type.SmileyDataObject;
import de.communardo.confluence.plugins.metadataintegration.type.SmileyMetadataFieldType;
import org.apache.commons.lang.StringUtils;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

@Path(CqlSmileyResources.RESOURCE_PATH)
public class CqlSmileyResources {
    static final String RESOURCE_PATH = "/smiley-values";
    static final String FILTER_SUB_PATH = "/{metadataFieldId}";
    private final MetadataManager metadataManager;

    public CqlSmileyResources(MetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    @GET
    @Produces({MediaType.APPLICATION_JSON})
    @Path(FILTER_SUB_PATH)
    public Response searchConfluenceSmileys(
            @PathParam(value = "metadataFieldId") long metadataFieldId,
            @QueryParam(value = "query") String query,
            @Context UriInfo uriInfo) {

        List<CqlMetadataSmileyEntity> results = new ArrayList<>();
        List<CqlMetadataSmileyEntity> suggestedResults = new ArrayList<>();

        MetadataField metadataField = metadataManager.loadMetadataField(metadataFieldId);
        if (metadataField != null) {
            MetadataFieldType fieldType = metadataField.getType();

            if (fieldType instanceof SmileyMetadataFieldType) {
                SmileyMetadataFieldType smileyType = (SmileyMetadataFieldType) fieldType;
                SmileyMetadataFieldType.SmileyStyle smileyStyleConfiguration = smileyType.loadSmileyStyle();

                for (SmileyDataObject smileyDataObject : SmileyDataObject.getAllSmilies()) {
                    String smileyId = String.valueOf(smileyDataObject.getId());
                    CqlMetadataSmileyEntity cqlMetadataSmileyEntity = new CqlMetadataSmileyEntity(smileyId, smileyDataObject.getEmojiCharacters(smileyStyleConfiguration));
                    if (StringUtils.isBlank(query)) {
                        suggestedResults.add(cqlMetadataSmileyEntity);
                    } else if (smileyId.toLowerCase().contains(query.toLowerCase())) {
                        results.add(cqlMetadataSmileyEntity);
                    }
                }
            }
        }
        return Response.ok(new CqlSmileyResultEntity(results, suggestedResults)).build();
    }

}
