package de.communardo.confluence.plugins.metadataintegration.type.cql;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Collection;

@XmlRootElement
public class CqlSmileyResultEntity {

    @XmlAttribute
    private final Collection<CqlMetadataSmileyEntity> searchResults;

    @XmlAttribute
    private final Collection<CqlMetadataSmileyEntity> suggestedResults;

    public CqlSmileyResultEntity(Collection<CqlMetadataSmileyEntity> results, Collection<CqlMetadataSmileyEntity> suggestedResults) {
        this.searchResults = results;
        this.suggestedResults = suggestedResults;
    }

    public Collection<CqlMetadataSmileyEntity> getSearchResults() {
        return searchResults;
    }

    public Collection<CqlMetadataSmileyEntity> getSuggestedResults() {
        return suggestedResults;
    }

}

