package de.communardo.confluence.plugins.metadataintegration.type.cql;

import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.EqualityFieldHandler;
import com.atlassian.querylang.fields.FieldMetaData;
import com.atlassian.querylang.fields.expressiondata.EqualityExpressionData;
import com.atlassian.querylang.fields.expressiondata.SetExpressionData;
import com.communardo.confluence.metadata.cql.MetadataSchemaField;
import com.google.common.collect.ImmutableSet;

import static com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper.joinSingleValueQueries;
import static com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper.wrapV2Search;
import static com.atlassian.querylang.fields.expressiondata.EqualityExpressionData.Operator.EQUALS;
import static com.atlassian.querylang.fields.expressiondata.EqualityExpressionData.Operator.NOT_EQUALS;
import static com.atlassian.querylang.fields.expressiondata.SetExpressionData.Operator.IN;
import static com.atlassian.querylang.fields.expressiondata.SetExpressionData.Operator.NOT_IN;

public class SmileyMetadataFieldHandler extends BaseFieldHandler
        implements EqualityFieldHandler<String, V2SearchQueryWrapper> {
    private final MetadataSchemaField schemaField;

    public SmileyMetadataFieldHandler(MetadataSchemaField schemaField, boolean orderSupported) {
        super(schemaField.getAlias(), FieldMetaData.builder().isAlias(true).uiSupport(schemaField.getUiSupport()).build(), orderSupported);
        this.schemaField = schemaField;
    }

    @Override
    public V2SearchQueryWrapper build(SetExpressionData setExpressionData, Iterable<String> values) {

        validateSupportedOp(setExpressionData.getOperator(), ImmutableSet.of(IN, NOT_IN));
        SearchQuery query = joinSingleValueQueries(values, this::createEqualityQuery);
        return wrapV2Search(query, setExpressionData);
    }


    @Override
    public V2SearchQueryWrapper build(EqualityExpressionData equalityExpressionData, String value) {
        validateSupportedOp(equalityExpressionData.getOperator(), ImmutableSet.of(EQUALS, NOT_EQUALS));
        return wrapV2Search(createEqualityQuery(value), equalityExpressionData);
    }


    private TermQuery createEqualityQuery(String value) {
        return new TermQuery(schemaField.getFieldName(), value);
    }

}
