/*
 * Decompiled with CFR 0.152.
 */
package ch.bitvoodoo.apps.aduno.congrats;

import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class SyncMain {
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public static void main(String[] args) {
        String file = System.getProperty("syncFile");
        String baseUrl = System.getProperty("baseUrl");
        String username = System.getProperty("username");
        String password = System.getProperty("password");
        String fieldId = System.getProperty("fieldId");
        if (StringUtils.isEmpty(fieldId)) {
            fieldId = "1";
        }
        if (StringUtils.isEmpty(file)) {
            System.out.println("PLease specify a file with -DsyncFile");
            return;
        }
        if (StringUtils.isEmpty(baseUrl)) {
            System.out.println("PLease specify a baseUrl with -DbaseUrl");
            return;
        }
        if (StringUtils.isEmpty(username)) {
            System.out.println("PLease specify a username with -Dusername");
            return;
        }
        if (StringUtils.isEmpty(password)) {
            System.out.println("PLease specify a password with -Dpassword");
            return;
        }
        String endpoint = baseUrl + "/rest/congrats/1.0/fields/" + fieldId + "/value.json";
        System.out.println("Endpoint :" + endpoint);
        try {
            POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(file));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            int cols = 0;
            int tmp = 0;
            for (int i = 0; i < 10 || i < rows; ++i) {
                HSSFRow row = sheet.getRow(i);
                if (row == null || (tmp = sheet.getRow(i).getPhysicalNumberOfCells()) <= cols) continue;
                cols = tmp;
            }
            for (int r = 0; r < rows; ++r) {
                SyncMain.importRow(sheet.getRow(r), endpoint, username, password);
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    private static void importRow(HSSFRow row, String endpoint, String username, String password) {
        if (row != null) {
            HSSFCell userNameCell = row.getCell(0);
            HSSFCell birthDayCell = row.getCell(1);
            if (1 == userNameCell.getCellType() && StringUtils.isNotBlank(userNameCell.getStringCellValue()) && 0 == birthDayCell.getCellType() && HSSFDateUtil.isCellDateFormatted(birthDayCell) && birthDayCell.getDateCellValue() != null) {
                SyncMain.setBirtday(userNameCell.getStringCellValue(), birthDayCell.getDateCellValue(), endpoint, username, password);
            }
        }
    }

    public static void setBirtday(String targetUser, Date date, String endpoint, String username, String password) {
        String formatDate = SyncMain.formatDate(date);
        if (StringUtils.isNotBlank(formatDate) && StringUtils.isNotBlank(targetUser)) {
            try {
                String authString = username + ":" + password;
                byte[] authEncBytes = Base64.getEncoder().encode(authString.getBytes());
                String authStringEnc = new String(authEncBytes);
                String urlParameters = "date=" + formatDate + "&username=" + targetUser;
                byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
                int postDataLength = postData.length;
                HttpURLConnection urlConnection = (HttpURLConnection)new URL(endpoint).openConnection();
                urlConnection.setDoOutput(true);
                urlConnection.setInstanceFollowRedirects(false);
                urlConnection.setRequestProperty("Authorization", "Basic " + authStringEnc);
                urlConnection.setRequestMethod("POST");
                urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                urlConnection.setRequestProperty("X-Atlassian-Token", "nocheck");
                urlConnection.setRequestProperty("charset", "utf-8");
                urlConnection.setRequestProperty("Content-Length", Integer.toString(postDataLength));
                urlConnection.setUseCaches(false);
                try (DataOutputStream wr = new DataOutputStream(urlConnection.getOutputStream());){
                    wr.write(postData);
                }
                InputStream response = urlConnection.getInputStream();
                System.out.println("Imported " + targetUser + " with date " + formatDate);
            }
            catch (MalformedURLException e) {
                System.out.println("Error import " + targetUser + " date:" + formatDate + " : " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("Error import " + targetUser + " date:" + formatDate + " : " + e.getMessage());
            }
        } else {
            System.out.println("Cannot import " + targetUser + " date:" + formatDate);
        }
    }

    public static String formatDate(Date value) {
        return SyncMain.getFormat(DATE_FORMAT).format(value);
    }

    private static DateFormat getFormat(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setLenient(false);
        return dateFormat;
    }
}

